% Quasi random draws study #02-09-2015
% Second simulation, new designs (10 attributes)
% 
% clear all
% clc
% 
% % path MXL_final
% 
% global B_backup; % this one is for storing B in case iterations are interrupted with ctrl-c
% 
% %% ****************************  loading & specifying data ****************************
% 
% % EstimOpt.fnameinput = ('DESIGNSMXL'); % original designs
% % EstimOpt.fnameinput = ('DRAWS_3'); % original designs
% 
% EstimOpt.fnameinput = ('Drawy_MXL_20180319.mat'); % designs with 10 random variables
% 
% DATA = load(EstimOpt.fnameinput);
% 
% EstimOpt.NamesA = {'SQ'; 'ATT1'; 'ATT2'; 'ATT3'; 'FEE' };
% 
% %% ****************************  loading & specifying input ****************************
% 
% INPUT.Y = DATA.MXL.DESIGN1.Y3;
% INPUT.Xa = DATA.MXL.DESIGN1.X3;
% 
% % INPUT.MissingInd = zeros(size(INPUT.Y,1),1);
% 
% %% ****************************  sample characteristics ****************************
% 
% EstimOpt.NCT = DATA.MXL.DESIGN1.NCT3; % Number of choice tasks per person
% EstimOpt.NAlt = 3; % Number of alternatives
% EstimOpt.NP = DATA.MXL.DESIGN1.NP3; % Number of respondents
% 
% %% **************************** estimation and optimization options ****************************
% 
% % EstimOpt.eps = 1.e-9; % overall precision level
% 
% 
% [INPUT, Results, EstimOpt, OptimOpt] = DataCleanDCE(INPUT,EstimOpt);
% 
% % OptimOpt = optimoptions('fminunc');
% % % OptimOpt.Algorithm = 'quasi-newton'; %'trust-region';
% % OptimOpt.FinDiffType = 'forward';
% % EstimOpt.NumGrad = 0; % 1 for numerical gradient, 0 for analytical
% % OptimOpt.GradObj = 'on'; %'on';
% % OptimOpt.Hessian = 'user-supplied'; % ('off'), only used by trust-region
% % OptimOpt.MaxIter = 10000;
% % EstimOpt.EPS = 1.e-9; % overall precision level
% % EstimOpt.NSDSIM = 1e4; % no of draws for simulating standard deviations
% % EstimOpt.HessEstFix = 4; % use analytical hessian after estimation
% % EstimOpt.ApproxHess = 1; %
% % EstimOpt.ConstVarActive = 0;
% 
% EstimOpt.HessEstFix = 0; % use analytical hessian after estimation
% 
% 
% % **************************** Simulation options ****************************
% 
% SimOpt.N = 1000; %no. of simulations
% SimOpt.DrawsMat = [1 2 4 6]; %[1 2 5 6 8]; %type of draws used in every simulation
% SimOpt.NrepMat = [100 200 500 1000 2000 5000 10000 2e4 5e4 1e5]; %no of draws used in every simluation
% 
% %EstimOpt.NumGrad = 1;
% %% ************************** ModelOpt = MXL_d *******************************
% 
% 
% clocknote = clock;
% 
% EstimOpt.FullCov = 0;
% EstimOpt.DIST = zeros(size(INPUT.Xa,2)+1,1); % 0 - normal, -1 - constant, 1 - lognormal, 2 - Spike, 5 - Weibull; the first one is for the scale parameter (include even for MXL)
% EstimOpt.WTP_space = 0; % number of cost parameters for WTP-space estimation (need to come last in Xa)
% 
% SimResults.b = zeros(10, SimOpt.N, length(SimOpt.NrepMat),length(SimOpt.DrawsMat));
% SimResults.std = zeros(10, SimOpt.N, length(SimOpt.NrepMat),length(SimOpt.DrawsMat));
% SimResults.LL = zeros(SimOpt.N, length(SimOpt.NrepMat),length(SimOpt.DrawsMat));
% SimResults.Time = zeros(SimOpt.N, length(SimOpt.NrepMat),length(SimOpt.DrawsMat));
% SimResults.Seed = zeros(SimOpt.N, length(SimOpt.NrepMat),length(SimOpt.DrawsMat));
% 
% EstimOpt.BACTIVE = ones(10,1);
% EstimOpt.BACTIVE(6,1) = 0;
% 
% save mxl_10_13_tmp
 

try
    
    clear all
    clc
    load('mxl_10_13_tmp.mat')
    
    EstimOpt.RealMin = 1;
    
    SimOpt.N = 1000; %no. of simulations
    SimOpt.DrawsMat = [1 2 4 6]; %[1 2 5 6 8]; %type of draws used in every simulation
    SimOpt.NrepMat = [100 200 500 1000 2000 5000 10000 2e4 5e4 1e5]; %no of draws used in every simluation
    
    SimResults.b(20,SimOpt.N,length(SimOpt.NrepMat),length(SimOpt.DrawsMat)) = 0;
    SimResults.std(20,SimOpt.N,length(SimOpt.NrepMat),length(SimOpt.DrawsMat)) = 0;
    SimResults.LL(SimOpt.N,length(SimOpt.NrepMat),length(SimOpt.DrawsMat)) = 0;
    SimResults.Time(SimOpt.N,length(SimOpt.NrepMat),length(SimOpt.DrawsMat)) = 0;
    SimResults.Seed(SimOpt.N,length(SimOpt.NrepMat),length(SimOpt.DrawsMat)) = 0;
    
    
    clocknote = clock;
    
    
    for i = 1 : length(SimOpt.NrepMat)
        EstimOpt.NRep = SimOpt.NrepMat(i);
        for n = 3 : length(SimOpt.DrawsMat)
            EstimOpt.Draws = SimOpt.DrawsMat(n);
            for j = 1 : 1000 % SimOpt.N
                disp([num2str(n,'%1.0f'), '/', num2str(length(SimOpt.DrawsMat), '%1.0f'), ' type of draws, ', num2str(i,'%1.0f'), '/', num2str(length(SimOpt.NrepMat), '%1.0f'), ' NREP values, ', num2str(j,'%1.0f'), '/', num2str(SimOpt.N,'%1.0f'), ' simulations'])
                if SimResults.LL(j,i,n) ~= 0 && ~isnan(SimResults.LL(j,i,n))
                    continue
                else
                    B_backup = [];
                    Results.MXL_d.b0 = [ones(10,1); sqrt(0.5)*ones(10,1)];
                    Results.MXL_d = MXL(INPUT,Results,EstimOpt,OptimOpt);
                    SimResults.b(:,j,i,n) = [Results.MXL_d.DetailsA(:,1); Results.MXL_d.DetailsV(:,1)];
                    SimResults.std(:,j,i,n) = [Results.MXL_d.DetailsA(:,2); Results.MXL_d.DetailsV(:,2)];
                    SimResults.LL(j,i,n) = Results.MXL_d.LL;
                    SimResults.Seed(j,i,n) = Results.MXL_d.Seed;
                    SimResults.Time(j,i,n) = Results.MXL_d.tocnote;
                end
            end
            
                if rem(j,100)==0
                    save mxl_10_13_tmp  
                end
        end
        clc
    end
    SimResults.Opt = SimOpt;
    
    e_time = etime(clock,clocknote);
    clocknote = clock;
    [~,DayName] = weekday(now,'long');
    disp([' ']);disp([' ']);
    disp(['Estimation completed on ' DayName ', ' num2str(clocknote(1)) '-' sprintf('%02.0f',clocknote(2)) '-' sprintf('%02.0f',clocknote(3)) ' at ' sprintf('%02.0f',clocknote(4)) ':' sprintf('%02.0f',clocknote(5)) ':' sprintf('%02.0f',clocknote(6))])
    disp(['Estimation took ' num2str(e_time) ' seconds ('  num2str(floor(e_time/(60*60))) ' hours ' num2str(floor(rem(e_time,60*60)/60)) ' minutes ' num2str(rem(e_time,60)) ' seconds).']);
    
    sendmail('mik@czaj.org','MATLAB: D4 - done!');
    
catch theErrorInfo
    
    sendmail('mik@czaj.org','MATLAB: D4 - error!');
    
end



